#ifndef __ACTIVYLCD_CPP
#define __ACTIVYLCD_CPP

#include "activylcd.h"

///////////////////////////////////////////////////
// activy300 LCD plugin for VDR
//
// Original written by:
//
// Meinrad Sauter <meinrad.sauter@gmx.de>
// andreas 'randy' weinberger <vdr@smue.org>
//
// rearranged, beautified and rewritten by:
//
// Markus Geisler <geisler@primusnetz.de>
//

/////////////////////////////////////////////////////////
// Konstruktor

activyLCD::activyLCD()
{
  	LCDInit();  
	char inittext1[21];
	char inittext2[21];
	snprintf(inittext1,21," FSC ACTIVY300 LCD  ");
	snprintf(inittext2,21," -- initalizing --  ");
	SetLCDLines(inittext1,inittext2);
	sleep(2);
	snprintf(inittext1,21,"   plugin for VDR   ");
	snprintf(inittext2,21,"  mg@primusnetz.de  ");
	SetLCDLines(inittext1,inittext2);
	sleep(2);
}

/////////////////////////////////////////////////////////
// Destruktor

activyLCD::~activyLCD()
{
  	LCDClear();
  	SetPowerButton(1);
  	SetLEDBrightness(LEDBrightnessOnExit);
  	SerialPortClose();
}

/////////////////////////////////////////////////////////
// Open Serial Port

int activyLCD::SerialPortOpen(void)
{
	// open serial device
  	fd = open(LCD_PORT, O_RDWR | O_NOCTTY | O_NDELAY);

	// check result
  	if (fd == -1) 
	{
		// error - port could not be opened
		return(-1);
  	} 
	else 
	{
		// ok - port opened
    		fcntl(fd, F_SETFL, 0);
		struct termios options;
	  	// Get the current options for the port...
		tcgetattr(fd, &options);
	  	// Set the baud rates to 38400...
	  	cfsetispeed(&options, B38400);
	  	cfsetospeed(&options, B38400);
	  	// Enable the receiver and set local mode...
	  	options.c_cflag |= (CLOCAL);
	  	options.c_cflag &= ~PARENB;
	  	options.c_cflag &= ~CSTOPB;
	  	options.c_cflag &= ~CSIZE;
	  	options.c_cflag |= CS8;
	  	options.c_oflag &= ~OPOST;
	  	// Set the new options for the port...
	  	tcsetattr(fd, TCSANOW, &options);

	  	return (fd);
  	}
}

/////////////////////////////////////////////////////////
// Close Serial Port

void activyLCD::SerialPortClose()
{
  	close(fd);
}

/////////////////////////////////////////////////////////
// Send Command to LCD-Device

void activyLCD::SendCommandToLCD(char *command,int length)
{
  	SerialPortOpen();
  	write(fd,command,length);
//	isyslog(command);
  	SerialPortClose();
	usleep(10000);
}

/////////////////////////////////////////////////////////
// Init LCD Device

void activyLCD::LCDInit()
{
//  	LCDClear();
  	if(PowerButton)
  	{
    		SetPowerButton(1);
  	} 
	else 
	{
    		SetPowerButton(0);
  	}
  	SetLEDBrightness(LEDBrightness);
}

/////////////////////////////////////////////////////////
// Replace German Umlauts

char *activyLCD::ReplaceUmlaute(const char *line)
{
  	int b;  
  	char c;
  	char replacetemp1[strlen(line)*2];
	char *linetemp;
        char replaced[strlen(line)*2];

	int size = strlen(line);

  	replacetemp1[0]='\0'; 
  	memset(replaced,' ',strlen(line)*2);

	linetemp = strdup(line);

  	for (b=0; b<size; b++) 
	{
  	  	c = linetemp[b];

   	 	switch(c) 
		{
     	 		case '\x09':
      	  		strcat(replacetemp1," ");
        		break; 

    	 		case '':
      	  		strcat(replacetemp1,"ae");
        		break; 

      			case '':
        		strcat(replacetemp1,"oe");
        		break; 

      			case '':
        		strcat(replacetemp1,"ue");
        		break; 

      			case '':
        		strcat(replacetemp1,"ss");
        		break; 

      			case '':
        		strcat(replacetemp1,"Ae");
        		break; 

      			case '':
        		strcat(replacetemp1,"Oe");
        		break; 

      			case '':
        		strcat(replacetemp1,"Ue");
        		break;

      			default:
        		replacetemp1[strlen(replacetemp1) + 1]=0;
        		replacetemp1[strlen(replacetemp1)] = c;
    		};
  	};
  	replacetemp1[strlen(replacetemp1)+1]='\0';

//	size = strlen(replacetemp1);
//
//  	for (b=0; b<size; b++) 
//	{
//  	  	c = replacetemp1[b];
//
//		if(isspace(c))
//		{
//			replacetemp1[b] = ' ';
//		}
//	}

	return(strdup(replacetemp1));
}


/////////////////////////////////////////////////////////
// Set LCD-Lines on LCD

void activyLCD::SetLCDLines(char text1[21],  char text2[21])
{
  	LCDInit();

  	char text[21];
	char output[30];

	// 1. Line zusammensetzen
  	memset(text,' ',21);
  	snprintf(text,21,"%-20s",text1);

	// Display 1. Line clearen
  	snprintf(output,3, "%s%c", LCD_WRITE_TEXT_LINE0, '\x00');
  	SendCommandToLCD(output,3 );

	// Display 1. Line setzen
  	snprintf(output,23, "%s%s%c", LCD_WRITE_TEXT_LINE0, text, '\x00');
  	SendCommandToLCD(output,23 );

	// 2. Line zusammensetzen
  	memset(text,' ',21);
  	snprintf(text,21,"%-20s",text2);

	// Display 2. Line clearen
 	snprintf(output,3, "%s%c", LCD_WRITE_TEXT_LINE1, '\x00');
  	SendCommandToLCD(output,3 );

	// Display 2. Line setzen
  	snprintf(output,23, "%s%s%c", LCD_WRITE_TEXT_LINE1, text,'\x00');
  	SendCommandToLCD(output,23 );
}

/////////////////////////////////////////////////////////
// Set LCD-Line0 on LCD

void activyLCD::SetLCDLine0(char *text1)
{
  	LCDInit();

  	char text[21];
	char output[30];

	// 1. Line zusammensetzen
  	memset(text,' ',21);
  	snprintf(text,21,"%-20s",ReplaceUmlaute(text1));

	// Display 1. Line setzen
  	snprintf(output,23, "%s%s%c", LCD_WRITE_TEXT_LINE0, text, '\x00');
  	SendCommandToLCD(output,23 );
}

/////////////////////////////////////////////////////////
// Set LCD-Line1 on LCD

void activyLCD::SetLCDLine1(char *text1)
{
  	LCDInit();

  	char text[21];
	char output[30];

	// 1. Line zusammensetzen
  	memset(text,' ',21);
  	snprintf(text,21,"%-20s",ReplaceUmlaute(text1));

	// Display 1. Line setzen
  	snprintf(output,23, "%s%s%c", LCD_WRITE_TEXT_LINE1, text, '\x00');
  	SendCommandToLCD(output,23 );
}

/////////////////////////////////////////////////////////
// Clear LCD Device

void activyLCD::LCDClear() // clears the lcd display
{
	char output[30];

  	snprintf(output,2, "%s%c", LCD_CLEAR, '\x00');
  	SendCommandToLCD(output,2 );
}

/////////////////////////////////////////////////////////
// Set Power Button

void activyLCD::SetPowerButton(bool status) // switch powerbutton on
{
	char output[30];

  	switch (status) 
	{
    		case 0:
      		snprintf(output,2, "%s", POWERBUTTON_SCANCODE_OFF);
		SendCommandToLCD(output,2 );
      		snprintf(output,2, "%s", POWERBUTTON_OFF);
  		SendCommandToLCD(output,2 );
      		break;

    		case 1:
      		snprintf(output,2, "%s", POWERBUTTON_SCANCODE_ON);
  		SendCommandToLCD(output,2 );
      		snprintf(output,2, "%s", POWERBUTTON_ON);
		SendCommandToLCD(output,2 );
      		break;
  	}
}

/////////////////////////////////////////////////////////
// Set LED Brightness

void activyLCD::SetLEDBrightness(const int brightness)
{
 	int brightness_temp = 0;
	char output[30];

  	switch(brightness) 
	{ 
    		case 0: // superbright
      		brightness_temp = 0;
      		break;

    		case 1: // bright
      		brightness_temp = 50;
      		break;

    		case 2: // semibright
      		brightness_temp = 100;
      		break;

    		case 3: // dark
      		brightness_temp = 150;
      		break;

    		case 4: // off
      		brightness_temp = 255;
      		break;
	}

  	snprintf(output,2, "%s%c", LCD_LEDBRIGHTNESS, brightness_temp);
 	SendCommandToLCD(output,2 );
}

#endif
