#ifndef __ACTIVYLCD_H
#define __ACTIVYLCD_H

#include <sys/time.h>
#include <ctype.h>
#include <stdio.h>   /* Standard input/output definitions */
#include <string.h>  /* String function definitions */
#include <unistd.h>  /* UNIX standard function definitions */
#include <fcntl.h>   /* File control definitions */
#include <errno.h>   /* Error number definitions */
#include <termios.h> /* POSIX terminal control definitions */
#include <math.h>
#include <time.h>

#include <vdr/tools.h>

extern int PowerButton;
extern int LEDBrightness;
extern int LEDBrightnessOnExit;

///////////////////////////////////////////////////
// activy300 LCD plugin for VDR
//
// Original written by:
//
// Meinrad Sauter <meinrad.sauter@gmx.de>
// andreas 'randy' weinberger <vdr@smue.org>
//
// rearranged, beautified and rewritten by:
//
// Markus Geisler <geisler@primusnetz.de>
//


///////////////////////////////////////////////////
// DEFINITIONS 

#define LCD_PORT "/dev/ttyS0"

#define POWERLED_GREEN_BLINK     "\x90\x80"
#define POWERLED_GREEN_ON        "\x90\x08" // or "0x90 0x01"
#define POWERLED_RED_ON	         "\x90\x10"
#define BASICLED_ON		 "\x90\x40"
#define BASICLED_OFF		 "\x90\x04"
#define MESSAGELED_BLINK_ON	 "\x90\x20"
#define MESSAGELED_OFF		 "\x90\x02"

#define POWERBUTTON_ON		 "\x94\x12" // setkeycodes e010 xx
#define POWERBUTTON_OFF		 "\x94\x21"
#define POWERBUTTON_SCANCODE_ON  "\x94\x03"
#define POWERBUTTON_SCANCODE_OFF "\x94\x30"

#define LCD_WRITE_TEXT_LINE0	 "\x9A\x02" // + \x00
#define LCD_WRITE_TEXT_LINE1	 "\x9A\x03" // + \x00
#define LCD_CLEAR		 "\x9B"     // + \x00
#define LCD_LEDBRIGHTNESS	 "\xF0"

///////////////////////////////////////////////////
// class activyLCD

class activyLCD 
{
 	private:

	// filedescriptor for serial port
  	int fd;

 	public:

	// public member functions
  	activyLCD();
  	~activyLCD();
  	int SerialPortOpen(void);
  	void SerialPortClose();
  	void LCDInit();
  	void LCDClear();
  	char *ReplaceUmlaute(const char *line);
  	void SendCommandToLCD(char *command, int length);
  	void SetLEDBrightness(const int brightness);
  	void SetLCDLines(char text1[21], char text2[21]);
  	void SetLCDLine0(char *text);
  	void SetLCDLine1(char *text);
  	void SetPowerButton(bool status);
};

#endif
