#ifndef __ALCD_THREAD_CPP
#define __ALCD_THREAD_CPP

#include "alcd-thread.h"


///////////////////////////////////////////////////
// activy300 LCD plugin for VDR
//
// Original written by:
//
// Meinrad Sauter <meinrad.sauter@gmx.de>
// andreas 'randy' weinberger <vdr@smue.org>
//
// rearranged, beautified and rewritten by:
//
// Markus Geisler <geisler@primusnetz.de>
//

/////////////////////////////////////////////////////////
// Konstruktor

aLCD::aLCD()
{
	// new instance of LCD
	myLCD = new activyLCD();

	// waittimer for status messages
	wait = 0;
   	refresh = 0;

  	stop = false;
  	title = false;

        linesize0 = 0;
        leftborder0 = 0;
        rightborder0 = 0;
        currentborder0 = 0;
        linesize1 = 0;
        leftborder1 = 0;
        rightborder1 = 0;
        currentborder1 = 0;
        scrolling1 = 0;

        LCDLine0 = strdup("");
        LCDLine1 = strdup("");
        LCDoldLine0 = strdup("");
        LCDoldLine1 = strdup("");
        LCDrecLine0 = strdup("");
        LCDrecLine1 = strdup("");
        LCDvolLine0 = strdup("");
        LCDvolLine1 = strdup("");
        LCDplayLine0 = strdup("");
        LCDplayLine1 = strdup("");
        LCDmenuLine0 = strdup("");
        LCDmenuLine1 = strdup("");
        LCDChannelLine0 = strdup("");
        LCDChannelLine1 = strdup("");

  	memset(line0,' ',20);
  	memset(line1,' ',20);
  	memset(oldline0,' ',20);
  	memset(oldline1,' ',20);
  	memset(templine0,' ',20);
  	memset(templine1,' ',20);

  	myLCD->LCDInit();  

  	refresh = 1;
}

/////////////////////////////////////////////////////////
// Destruktor

aLCD::~aLCD()
{
  	stop = true;
  	while (running) usleep(100000);
  	myLCD->LCDClear();
  	myLCD->SetPowerButton(1);
  	myLCD->SetLEDBrightness(LEDBrightnessOnExit);
  	myLCD->SerialPortClose();
}

/////////////////////////////////////////////////////////
// Reset Class Values

void aLCD::reset()
{
	if (strcmp(LCDLine0,LCDoldLine0)!=0 && refresh)
	{
	        linesize0 = 0;
	        leftborder0 = 0;
	        rightborder0 = 0;
	        currentborder0 = 0;
	        scrolling0 = 0;
	}

       	if (strcmp(LCDLine1,LCDoldLine1)!=0 && refresh)
	{
		linesize1 = 0;
	        leftborder1 = 0;
	        rightborder1 = 0;
	        currentborder1 = 0;
	        scrolling1 = 0;
	}
}

/////////////////////////////////////////////////////////
// Set Channel Name

void aLCD::SetChannelName (const char *Name)
{
	lcdmodus = 0;
	reset();

	if(LCDChannelLine0)
	{
		free(LCDChannelLine0);
	}

	if(Name)
	{
		LCDChannelLine0 = strdup(myLCD->ReplaceUmlaute(Name));
	}
	else
	{
		LCDChannelLine0 = strdup("- keine Daten -");
	}
}

/////////////////////////////////////////////////////////
// Set Programm

void aLCD::SetProgramme (const char *PresentTitle)
{
	lcdmodus = 0;
	reset();

	if(LCDChannelLine1)
	{
		free(LCDChannelLine1);
	}

	if(PresentTitle)
	{
		LCDChannelLine1 = strdup(myLCD->ReplaceUmlaute(PresentTitle));
	}
	else
	{
		LCDChannelLine1 = strdup("- keine Daten -");
	}
}

/////////////////////////////////////////////////////////
// Set Recording

void aLCD::SetRecording(int card, const char *Name)
{
	char output[30];
	char *replaced;

	reset();

  	if(Name) 
	{
    		switch (RecordLED) 
		{
      			case 1:
			snprintf(output,2, "%s", MESSAGELED_BLINK_ON);
  			myLCD->SendCommandToLCD(output,2 );
			snprintf(output,2, "%s", BASICLED_OFF);
  			myLCD->SendCommandToLCD(output,2 );
        		break;

      			case 2:
			snprintf(output,2, "%s",BASICLED_ON);
  			myLCD->SendCommandToLCD(output,2 );
			snprintf(output,2, "%s",MESSAGELED_OFF);
  			myLCD->SendCommandToLCD(output,2 );
        		break;
    		};


		if(LCDrecLine0)
		{
			free(LCDrecLine0);
		}
	
    		snprintf(templine0,21,tr("Recording started:"));
		LCDrecLine0 = strdup(templine0);

		if(LCDrecLine1)
		{
			free(LCDrecLine1);
		}

   		snprintf(RecordName,41,"%s", Name);
    		replaced = myLCD->ReplaceUmlaute(RecordName);
    		snprintf(templine1,21,"%-20s",replaced);
		LCDrecLine1 = strdup(templine1);
  		lcdmodus = 1;
  	} 
	else 
	{
    		snprintf(output,2, "%s", MESSAGELED_OFF);
  		myLCD->SendCommandToLCD(output,2 );
    		snprintf(output,2, "%s", BASICLED_OFF);
  		myLCD->SendCommandToLCD(output,2 );

		if(LCDrecLine0)
		{
			free(LCDrecLine0);
		}

    		snprintf(templine0,21,tr("Recording stopped:"));
		LCDrecLine0 = strdup(templine0);

  		if(LCDrecLine1)
		{
			free(LCDrecLine1);
		}

    		replaced = myLCD->ReplaceUmlaute(RecordName);
    		snprintf(templine1,21,"%-20s",replaced);
		LCDrecLine1 = strdup(templine1);
	};
}

/////////////////////////////////////////////////////////
// Replay Control

void aLCD::ReplayControl(cControl *Control, const char *Name)
{
//	char *replaced;

	reset();

	if(Name)
	{
    		lcdmodus = 3;
    		PlayControl = Control;

		if(LCDplayLine0)
		{
			free(LCDplayLine0);
		}

		if(LCDplayLine1)
		{
			free(LCDplayLine1);
		}

//    		replaced = myLCD->ReplaceUmlaute(Name);
		LCDplayLine0 = strdup(myLCD->ReplaceUmlaute(Name));
		LCDplayLine1 = strdup("                  > ");
  	}
	else
	{
    		lcdmodus = 0;
  	} 
}

/////////////////////////////////////////////////////////
// Menu Control

void aLCD::SetCurrentItem(const char *Text)
{
	reset();

//	char *replaced;

	if(Text)
	{
		lcdmodus = 4;
//	    	replaced = myLCD->ReplaceUmlaute(Text);

		if(LCDmenuLine1)
		{
			free(LCDmenuLine1);
		}

		LCDmenuLine1 = strdup(myLCD->ReplaceUmlaute(Text));
	}
	else
	{
    		lcdmodus = 0;
  	} 
}

/////////////////////////////////////////////////////////
// Status Information

void aLCD::SetMessageText(const char *Text)
{
	reset();

	if(Text)
	{
		if(LCDoldLine0)
		{
			free(LCDoldLine0);
		}
	
		if(LCDmenuLine0)
		{
			LCDoldLine0 = strdup(LCDmenuLine0);
			free(LCDmenuLine0);
			LCDmenuLine0 = strdup(myLCD->ReplaceUmlaute(Text));
			usleep(50000);
			free(LCDmenuLine0);
			if(LCDoldLine0)
			{
				LCDmenuLine0 = strdup(LCDoldLine0);
			}
		}
	}
}

/////////////////////////////////////////////////////////
// Set Title

void aLCD::SetTitle(const char *Text)
{
	reset();

	if(Text)
	{
		if(LCDoldLine0)
		{
			free(LCDoldLine0);
		}

		if(LCDmenuLine0)
		{
			LCDoldLine0 = strdup(LCDmenuLine0);
			free(LCDmenuLine0);
			LCDmenuLine0 = strdup(myLCD->ReplaceUmlaute(Text));
		}
	}
}


/////////////////////////////////////////////////////////
// Menu Control

void aLCD::SetOsdClear()
{
	if(lcdmodus!=3)
	{
		lcdmodus=0;
	}

	reset();
}

/////////////////////////////////////////////////////////
// Set Volume

void aLCD::SetVolume (int volume, bool muted)
{
  	percent = (int) lround(volume/14); // 1 -> 18
  	if(muted)
  	{
    		snprintf(templine1,21,"[    -- MUTE --    ]");

  		if(LCDvolLine1)
		{
			free(LCDvolLine1);
		}

		LCDvolLine1 = strdup(templine1);
	} 
	else 
	{
    		SetVolumeBar(percent);
  	}
  	oldmodus=lcdmodus;
  	lcdmodus=2;
}

/////////////////////////////////////////////////////////
// Set Volume Bar

void aLCD::SetVolumeBar(int percent)
{
  	int temp;
  	char vol_temp[18];
  	for (temp=1;temp<percent+1;temp++) 
	{
    		strcat(vol_temp, "#");
  	}
  	snprintf(templine1,21,"[%-18s]", vol_temp);

	if(LCDvolLine1)
	{
		free(LCDvolLine1);
	}

	LCDvolLine1 = strdup(templine1);
}

/////////////////////////////////////////////////////////
// Set Progress Bar

void aLCD::SetProgressBar(int percent)
{
  	int temp;
  	char prog_temp[15];

    	for (temp=1;temp<percent+1;temp++) 
	{
    		strcat(prog_temp, "#");
  	}

  	snprintf(templine1,21,"[%-15s]", prog_temp);
	LCDChannelLine1 = strdup(templine1);
}

/////////////////////////////////////////////////////////
// Thread Action

void aLCD::Action(void)
{
  	running=true;

  	while(!stop)
	{
    		gettimeofday(&now,NULL);
    		struct tm uhr;
    		time_t val;

    		switch (lcdmodus) 
		{ 
			//
			// case 0 : Channeldisplay
			//

      			case 0: 
			val = time(NULL);
			localtime_r(&val,&uhr);
			snprintf(templine0,14,"%s",LCDChannelLine0);
        		snprintf(line0,21,"%-14s %02d:%02d", templine0, uhr.tm_hour, uhr.tm_min);
        		snprintf(line1,21,"%-20s", LCDChannelLine1);

			if(LCDLine0)
			{
				free(LCDLine0);
			}

			if(LCDLine1)
			{
				free(LCDLine1);
			}

			LCDLine0 = strdup(line0);
			LCDLine1 = strdup(LCDChannelLine1);

			linesize1 = strlen(LCDChannelLine1);

			if(linesize1 > 20)
			{
				if(scrolling1 == 0)
				{
					scrolling1 = 1;
				}

				// leftborder = linkester Index fuer Anzeige (Scrolling)
				leftborder1 = 0;
				// rightborder = rechtester Index fuer Anzeige (Scrolling)
				rightborder1 = linesize1 - 21;
				
        			snprintf(line1,21,"%-20s", &LCDChannelLine1[currentborder1]);

				if(LCDLine1)
				{
					free(LCDLine1);
				}
				LCDLine1 = strdup(&LCDChannelLine1[currentborder1]);

				if((currentborder1 <= rightborder1) && (scrolling1 == 1))
				{
					// scrolling = 1 -> rightscrolling
					scrolling1 = 1;
				}
				else
				{
					// scrolling = 2 -> leftscrolling
					scrolling1 = 2;
				}

				if((currentborder1 > leftborder1) && (scrolling1 == 2))
				{
					// scrolling = 2 -> leftscrolling
					scrolling1 = 2;
				}
				else
				{
					// scrolling = 1 -> rightscrolling
					scrolling1 = 1;
				}

				if(scrolling1 == 1)
				{
					currentborder1++;
				}

				if(scrolling1 == 2)
				{
					currentborder1--;
				}
			}
			else
			{
				scrolling1 = 0;
			}

			wait = 0;
        		break;

			//
			// case 1 : display recording
			//

      			case 1: 
        		snprintf(line0,21,"%-20s", LCDrecLine0);
        		snprintf(line1,21,"%-20s", LCDrecLine1);

			if(LCDLine0)
			{
				free(LCDLine0);
			}

			if(LCDLine1)
			{
				free(LCDLine1);
			}

			LCDLine0 = strdup(LCDrecLine0);
			LCDLine1 = strdup(LCDrecLine1);

        		wait++;
        		if(wait>(WaitTime*10)) 
			{
          			snprintf(line1,21,"%-20s", LCDChannelLine1);
          			lcdmodus = 0; // switch back to time / chan display
          			wait = 0;
        		};
			break;

			//
			// case 2 : display volume
			//

      			case 2: 
			val = time(NULL);
			localtime_r(&val,&uhr);
        		snprintf(line0,21,"%-14s %02d:%02d", LCDChannelLine0, uhr.tm_hour, uhr.tm_min);
        		snprintf(line1,21,"%-20s", LCDvolLine1);

			if(LCDLine0)
			{
				free(LCDLine0);
			}

			if(LCDLine1)
			{
				free(LCDLine1);
			}

			LCDLine0 = strdup(line0);
			LCDLine1 = strdup(LCDvolLine1);

        		wait++;
        		if(wait>(WaitTime*10)) 
			{
          			snprintf(line1,21,"%-20s", LCDvolLine1);
          			lcdmodus = 0; // switch back to time / chan display
          			wait = 0;
        		};
			break;

			//
			// case 3 : display replay information
			//

      			case 3: 
        		char PlaySymbol[3];
			char progress[8];
        		char IndexTime[10];
        		int Current, Total, Speed;
        		bool Play, Forward;
			float diff;
			float floatTotal;
			float proz;

			progress[7] = '\0';

        		if (PlayControl->GetReplayMode(Play,Forward,Speed)) 
			{
          			if (Play && Speed == -1)
				{
					snprintf(PlaySymbol,2,"%2s","> "); // Normal Replay
				}
          			if (!Play && Speed == -1)
				{
					snprintf(PlaySymbol,2,"%2s","||"); // Pause
				}
          			if (Forward && Speed != -1) 
				{
					snprintf(PlaySymbol,2,"%2s",">>"); // Fast Forward
				}
          			if (!Forward && Speed != -1) 
				{
					snprintf(PlaySymbol,2,"%2s","<<"); // Fast Backward
				}
        		}

        		if (PlayControl->GetIndex(Current,Total)) 
			{
				diff = (float) (Total - Current);
				floatTotal = (float) Total;
				proz = 7*(1-(diff/floatTotal));
				snprintf(templine0,21,"%i\n",(int)proz);

				if((int)proz >= 0)
				{
					progress[0] = '#';
					progress[1] = ' ';
					progress[2] = ' ';
					progress[3] = ' ';
					progress[4] = ' ';
					progress[5] = ' ';
					progress[6] = ' ';
				}
				if((int)proz >= 1)
				{
					progress[0] = '#';
					progress[1] = '#';
					progress[2] = ' ';
					progress[3] = ' ';
					progress[4] = ' ';
					progress[5] = ' ';
					progress[6] = ' ';
				}
				if((int)proz >= 2)
				{
					progress[0] = '#';
					progress[1] = '#';
					progress[2] = '#';
					progress[3] = ' ';
					progress[4] = ' ';
					progress[5] = ' ';
					progress[6] = ' ';
				}
				if((int)proz >= 3)
				{
					progress[0] = '#';
					progress[1] = '#';
					progress[2] = '#';
					progress[3] = '#';
					progress[4] = ' ';
					progress[5] = ' ';
					progress[6] = ' ';
				}
				if((int)proz >= 4)
				{
					progress[0] = '#';
					progress[1] = '#';
					progress[2] = '#';
					progress[3] = '#';
					progress[4] = '#';
					progress[5] = ' ';
					progress[6] = ' ';
				}
				if((int)proz >= 5)
				{
					progress[0] = '#';
					progress[1] = '#';
					progress[2] = '#';
					progress[3] = '#';
					progress[4] = '#';
					progress[5] = '#';
					progress[6] = ' ';
				}
				if((int)proz >= 6)
				{
					progress[0] = '#';
					progress[1] = '#';
					progress[2] = '#';
					progress[3] = '#';
					progress[4] = '#';
					progress[5] = '#';
					progress[6] = '#';
				}

	  			snprintf(IndexTime,10,"%-10s",IndexToHMSF(Current,false));
          //			snprintf(templine1,21,"%-17s %-2s",IndexTime, PlaySymbol);
          			snprintf(templine1,21,"%-10s |%-7s|",IndexTime, progress);
        		}

        		snprintf(line0,21,"%s", LCDplayLine0);
        		snprintf(line1,21,"%s", templine1);

			if(LCDLine0)
			{
				free(LCDLine0);
			}

			if(LCDLine1)
			{
				free(LCDLine1);
			}

			LCDLine0 = strdup(LCDplayLine0);
			LCDLine1 = strdup(templine1);

			linesize0 = strlen(LCDplayLine0);

			if(linesize0 > 20)
			{
				if(scrolling0 == 0)
				{
					scrolling0 = 1;
				}

				// leftborder = linkester Index fuer Anzeige (Scrolling)
				leftborder0 = 0;
				// rightborder = rechtester Index fuer Anzeige (Scrolling)
				rightborder0 = linesize0 - 21;
				
        			snprintf(line0,21,"%s", &LCDplayLine0[currentborder0]);

				if(LCDLine0)
				{
					free(LCDLine0);
				}
				LCDLine0 = strdup(&LCDplayLine0[currentborder0]);

				if((currentborder0 <= rightborder0) && (scrolling0 == 1))
				{
					// scrolling = 1 -> rightscrolling
					scrolling0 = 1;
				}
				else
				{
					// scrolling = 2 -> leftscrolling
					scrolling0 = 2;
				}

				if((currentborder0 > leftborder0) && (scrolling0 == 2))
				{
					// scrolling = 2 -> leftscrolling
					scrolling0 = 2;
				}
				else
				{
					// scrolling = 1 -> rightscrolling
					scrolling0 = 1;
				}

				if(scrolling0 == 1)
				{
					currentborder0++;
				}

				if(scrolling0 == 2)
				{
					currentborder0--;
				}
			}
			else
			{
				scrolling0 = 0;
			}

			break;

			//
			// case 4 : display menu
			//

      			case 4:
        		snprintf(line0,21,"%s", LCDmenuLine0);
        		snprintf(line1,21,"%s", LCDmenuLine1);

			if(LCDLine0)
			{
				free(LCDLine0);
			}

			if(LCDLine1)
			{
				free(LCDLine1);
			}

			LCDLine0 = strdup(LCDmenuLine0);
			LCDLine1 = strdup(LCDmenuLine1);

			linesize0 = strlen(LCDmenuLine0);

			if(linesize0 > 20)
			{
				if(scrolling0 == 0)
				{
					scrolling0 = 1;
				}

				// leftborder = linkester Index fuer Anzeige (Scrolling)
				leftborder0 = 0;
				// rightborder = rechtester Index fuer Anzeige (Scrolling)
				rightborder0 = linesize0 - 21;
				
        			snprintf(line0,21,"%s", &LCDmenuLine0[currentborder0]);

				if(LCDLine0)
				{
					free(LCDLine0);
				}
				LCDLine0 = strdup(&LCDmenuLine0[currentborder0]);

				if((currentborder0 <= rightborder0) && (scrolling0 == 1))
				{
					// scrolling = 1 -> rightscrolling
					scrolling0 = 1;
				}
				else
				{
					// scrolling = 2 -> leftscrolling
					scrolling0 = 2;
				}

				if((currentborder0 > leftborder0) && (scrolling0 == 2))
				{
					// scrolling = 2 -> leftscrolling
					scrolling0 = 2;
				}
				else
				{
					// scrolling = 1 -> rightscrolling
					scrolling0 = 1;
				}

				if(scrolling0 == 1)
				{
					currentborder0++;
				}

				if(scrolling0 == 2)
				{
					currentborder0--;
				}
			}
			else
			{
				scrolling0 = 0;
			}

			linesize1 = strlen(LCDmenuLine1);

			if(linesize1 > 20)
			{
				if(scrolling1 == 0)
				{
					scrolling1 = 1;
				}

				// leftborder = linkester Index fuer Anzeige (Scrolling)
				leftborder1 = 0;
				// rightborder = rechtester Index fuer Anzeige (Scrolling)
				rightborder1 = linesize1 - 21;
				
        			snprintf(line1,21,"%-20s", &LCDmenuLine1[currentborder1]);

				if(LCDLine1)
				{
					free(LCDLine1);
				}
				LCDLine1 = strdup(&LCDmenuLine1[currentborder1]);

				if((currentborder1 <= rightborder1) && (scrolling1 == 1))
				{
					// scrolling = 1 -> rightscrolling
					scrolling1 = 1;
				}
				else
				{
					// scrolling = 2 -> leftscrolling
					scrolling1 = 2;
				}

				if((currentborder1 > leftborder1) && (scrolling1 == 2))
				{
					// scrolling = 2 -> leftscrolling
					scrolling1 = 2;
				}
				else
				{
					// scrolling = 1 -> rightscrolling
					scrolling1 = 1;
				}

				if(scrolling1 == 1)
				{
					currentborder1++;
				}

				if(scrolling1 == 2)
				{
					currentborder1--;
				}
			}
			else
			{
				scrolling1 = 0;
			}

			wait = 0;
        		break;
    		}
    	
    		if (strcmp(LCDLine0,LCDoldLine0)!=0 && refresh)
		{
			if(LCDoldLine0)
			{
				free(LCDoldLine0);
			}

			LCDoldLine0 = strdup(LCDLine0);

      			myLCD->SetLCDLine0(LCDLine0);
		}

		if (strcmp(LCDLine1,LCDoldLine1)!=0 && refresh)
		{
      			if(LCDoldLine1)
			{
				free(LCDoldLine1);
			}

			LCDoldLine1 = strdup(LCDLine1);

			myLCD->SetLCDLine1(LCDLine1);
    		}

    //		usleep(1000-(now.tv_usec%100000));
		usleep(1000);
  	}
  	running=false;
}

#endif
