#ifndef __ALCD_THREAD_H
#define __ALCD_THREAD_H

#include <vdr/thread.h>
#include <vdr/player.h>
#include <sys/time.h>

#include "ctype.h"
#include "activylcd.h"
#include <stdio.h>   /* Standard input/output definitions */
#include <string.h>  /* String function definitions */
#include <unistd.h>  /* UNIX standard function definitions */
#include <fcntl.h>   /* File control definitions */
#include <errno.h>   /* Error number definitions */
#include <termios.h> /* POSIX terminal control definitions */
#include <math.h>
#include <time.h>

#include "i18n.h"
#include <vdr/tools.h>
#include <vdr/config.h>

#include <vdr/plugin.h>
#include <vdr/status.h>
#include <vdr/channels.h>

extern int PowerButton;
extern int WaitTime;
extern int RecordLED;
extern int LEDBrightness;
extern int LEDBrightnessOnExit;

///////////////////////////////////////////////////
// activy300 LCD plugin for VDR
//
// Original written by:
//
// Meinrad Sauter <meinrad.sauter@gmx.de>
// andreas 'randy' weinberger <vdr@smue.org>
//
// rearranged, beautified and rewritten by:
//
// Markus Geisler <geisler@primusnetz.de>
//


///////////////////////////////////////////////////
// aLCD wrapper thread class

class aLCD : public cThread 
{
 	private:
  	char line0[21];
  	char line1[21];
	char oldline0[21];
	char oldline1[21];
	char templine0[21];
	char templine1[21];
  	char RecordName[41];
	char *LCDLine0;
	char *LCDLine1;
	char *LCDoldLine0;
	char *LCDoldLine1;
	char *LCDrecLine0;
	char *LCDrecLine1;
	char *LCDvolLine0;
	char *LCDvolLine1;
	char *LCDplayLine0;
	char *LCDplayLine1;
	char *LCDmenuLine0;
	char *LCDmenuLine1;
	char *LCDChannelLine0;
	char *LCDChannelLine1;

        int linesize0;
        int leftborder0;
        int rightborder0;
        int currentborder0;
	int scrolling0;
        int linesize1;
        int leftborder1;
        int rightborder1;
        int currentborder1;
	int scrolling1;
  	int percent;
	int volume;
  	int wait;
  	int lcdmodus;
	int oldmodus;
  	bool stop;
	bool running;
	bool title;
  	struct timeval now;
  	int fd;
  	cControl *PlayControl;
	activyLCD *myLCD;

	void reset();
  	virtual void Action(void);

 	public:
  	bool refresh;

  	aLCD();
  	~aLCD();
  	void SetVolumeBar(int percent);
  	void SetProgressBar(int percent);
  	void SetChannelName(const char *Name);
  	void SetChannelInfo(const char *Info);
  	void ReplayControl(cControl *Control, const char *Name);
  	void SetRecording(int card, const char *Name);
  	void SetProgramme(const char *PresentTitle);
  	void SetCurrentItem(const char *Text);
  	void SetOsdClear();
  	void SetVolume(int volume, bool muted);
  	void SetMessageText(const char *Text);
  	void SetTitle(const char *Text);
};

#endif
