#ifndef __ALCD_CPP
#define __ALCD_CPP

#undef DEBUG

#include "alcd.h"

///////////////////////////////////////////////////
// activy300 LCD plugin for VDR
//
// Original written by:
//
// Meinrad Sauter <meinrad.sauter@gmx.de>
// andreas 'randy' weinberger <vdr@smue.org>
//
// rearranged, beautified and rewritten by:
//
// Markus Geisler <geisler@primusnetz.de>
//


///////////////////////////////////////////////////////////
// Class cAlcdStatus Member Implementations

cAlcdStatus::cAlcdStatus(aLCD *myLCD)
{
	LCD = myLCD;
}

void cAlcdStatus::ChannelSwitch(const cDevice *Device, int ChannelNumber)
{
#ifdef DEBUG
     	isyslog("Calling LCD->SetChannelName");
#endif

	switch (ChannelNumber)
    	{
    		case 0:
      		break; // TODO: Indicator during Channel Switching

    		default:
      		isyslog("ChanSwitch called with Device %d and ChanNr %d",Device->IsPrimaryDevice(),ChannelNumber);
      		if (Device->IsPrimaryDevice()) 
		{
			//	LCD->SetChannel(ChannelNumber);
			LCD->SetChannelName(Channels.GetByNumber(ChannelNumber)->Name());
      		}
    	}
}

void cAlcdStatus::Recording(const cDevice *Device, const char *Name)
{
#ifdef DEBUG
     	isyslog("Calling LCD->SetRecording");
#endif
  	LCD->SetRecording(Device->CardIndex(), Name);
}

void cAlcdStatus::Replaying(const cControl *Control, const char *Name)
{
#ifdef DEBUG
     	isyslog("Calling LCD->ReplayControl");
#endif
  	LCD->ReplayControl((cControl *) Control,Name);
}

void cAlcdStatus::OsdProgramme(time_t PresentTime, const char *PresentTitle, const char *PresentSubtitle, time_t FollowingTime, const char *FollowingTitle, const char *FollowingSubtitle)
{
#ifdef DEBUG
     	isyslog("Calling LCD->SetProgramme");
#endif
  	LCD->SetProgramme(PresentTitle);
}

void cAlcdStatus::OsdCurrentItem(const char *Text)
{
#ifdef DEBUG
     	isyslog("Calling LCD->SetCurrentItem");
#endif
	LCD->SetCurrentItem(Text);
}

void cAlcdStatus::OsdClear(void)
{
#ifdef DEBUG
     	isyslog("Calling LCD->SetOsdClear");
#endif
	LCD->SetOsdClear();
}

void cAlcdStatus::SetVolume(int Volume, bool mute)
{
#ifdef DEBUG
     	isyslog("Calling LCD->SetVolume");
#endif
  	LCD->SetVolume(Volume,mute);
}

void cAlcdStatus::OsdStatusMessage(const char *Message)
{
#ifdef DEBUG
     	isyslog("Calling LCD->SetMessageText");
#endif
	LCD->SetMessageText(Message);
}

void cAlcdStatus::OsdTitle(const char *Title)
{
#ifdef DEBUG
     	isyslog("Calling LCD->SetTitle");
#endif
	LCD->SetTitle(Title);
}

///////////////////////////////////////////////////////////
// Class cPluginAlcd Member Implementations

cPluginAlcd::cPluginAlcd(void)
{
  	// Initialize any member varaiables here.
  	// DON'T DO ANYTHING ELSE THAT MAY HAVE SIDE EFFECTS, REQUIRE GLOBAL
  	// VDR OBJECTS TO EXIST OR PRODUCE ANY OUTPUT!
	statusMonitor = NULL;
}

cPluginAlcd::~cPluginAlcd()
{
  	// Clean up after yourself!
  	delete statusMonitor;
  	delete LCD;
}

const char *cPluginAlcd::CommandLineHelp(void)
{
  	// Return a string that describes all known command line options.
  	return NULL;
}

bool cPluginAlcd::ProcessArgs(int argc, char *argv[])
{
  	// Implement command line argument processing here if applicable.
  	return true;
}

bool cPluginAlcd::Start(void)
{
     	isyslog("Calling cPluginAlcd::Start");
  	// Start any background activities the plugin shall perform.
  	RegisterI18n(Phrases);
  	LCD = new aLCD;
  	statusMonitor = new cAlcdStatus(LCD);
  	LCD->Start();
  	return true;
}

void cPluginAlcd::Housekeeping(void)
{
  	// Perform any cleanup or other regular tasks.
}

cOsdMenu *cPluginAlcd::MainMenuAction(void)
{
  	// Perform the action when selected from the main VDR menu.
  	return NULL;
}


///////////////////////////////////////////////////////////
// Class cMenuSetupAlcd Member Implementations

cMenuSetupAlcd::cMenuSetupAlcd(void)
{
	static const char *RecLED[3];
  	RecLED[0] = tr("off");
  	RecLED[1] = "Message LED";
  	RecLED[2] = "Basic LED";
  	static const char *LEDBright[5];
  	LEDBright[0] = tr("superbright");
  	LEDBright[1] = tr("bright");
  	LEDBright[2] = tr("semibright");
  	LEDBright[3] = tr("dark");
  	LEDBright[4] = tr("off");
  	newWaitTime = WaitTime;
  	newRecordLED = RecordLED;
  	newPowerButton = PowerButton;
  	newLEDBrightness = LEDBrightness;
  	newLEDBrightnessOnExit = LEDBrightnessOnExit;
  	Add(new cMenuEditBoolItem( tr("Power Button"), &newPowerButton, tr("off"), tr("on")));
  	Add(new cMenuEditIntItem( tr("Wait time (s)"), &newWaitTime, 0, 60));
  	Add(new cMenuEditStraItem( tr("Record LED"),  &newRecordLED, 3, RecLED)); 
  	Add(new cMenuEditStraItem( tr("Display Brightness"), &newLEDBrightness, 4, LEDBright));
  	Add(new cMenuEditStraItem( tr("Display Brightness on exit"), &newLEDBrightnessOnExit, 5, LEDBright));
}

void cMenuSetupAlcd::Store(void)
{
  	SetupStore("PowerButton", PowerButton = newPowerButton);
  	SetupStore("WaitTime", WaitTime = newWaitTime);
  	SetupStore("RecordLED", RecordLED = newRecordLED);
  	SetupStore("LEDBrightness", LEDBrightness = newLEDBrightness);
  	SetupStore("LEDBrightnessOnExit", LEDBrightnessOnExit = newLEDBrightnessOnExit);
//  	LCD->SetLEDBrightness(LEDBrightness);
}

cMenuSetupPage *cPluginAlcd::SetupMenu(void)
{
  	// Return a setup menu in case the plugin supports one.
  	return new cMenuSetupAlcd;
}

bool cPluginAlcd::SetupParse(const char *Name, const char *Value)
{
  	// Parse your own setup parameters and store their values.
  	if (!strcasecmp(Name, "PowerButton")) 
	{
		PowerButton = atoi(Value);
	}
  	else 
	if (!strcasecmp(Name, "WaitTime"))
	{ 
		WaitTime = atoi(Value);
	}
  	else 
	if (!strcasecmp(Name, "RecordLED"))
	{
		RecordLED = atoi(Value);
	}
  	else 
	if (!strcasecmp(Name, "LEDBrightness"))
	{
		LEDBrightness = atoi(Value);
	}
  	else 
	if (!strcasecmp(Name, "LEDBrightnessOnExit")) 
	{
		LEDBrightnessOnExit = atoi(Value);
	}
  	else
     	return false;

  	return true;
}


VDRPLUGINCREATOR(cPluginAlcd); // Don't touch this!

#endif
