#ifndef __ALCD_H
#define __ALCD_H

#include <vdr/plugin.h>
#include <vdr/status.h>
#include <vdr/channels.h>
#include "i18n.h"
#include "alcd-thread.h"

///////////////////////////////////////////////////
// activy300 LCD plugin for VDR
//
// Original written by:
//
// Meinrad Sauter <meinrad.sauter@gmx.de>
// andreas 'randy' weinberger <vdr@smue.org>
//
// rearranged, beautified and rewritten by:
//
// Markus Geisler <geisler@primusnetz.de>
//


// Statische Variablen
static const char *VERSION        = "0.0.11-MAGE";
static const char *DESCRIPTION    = "Activy300 LCD-Plugin";
static const char *MAINMENUENTRY  = NULL;

// sonstige Variablen
int PowerButton = 0; // PowerButton off
int WaitTime = 2;
int RecordLED = 1; // Message LED
int LEDBrightness = 0; // Brightness 0 == bright, 4 == dark...
int LEDBrightnessOnExit = 4;

///////////////////////////////////////////////////
// Class cAlcdStatus
class cAlcdStatus : public cStatus 
{
	private:
	aLCD *LCD;

	protected:
	virtual void ChannelSwitch(const cDevice *Device, int ChannelNumber);
	virtual void Recording(const cDevice *Device, const char *Name);
	virtual void Replaying(const cControl *Control, const char *Name);
	virtual void SetVolume(int Volume, bool mute);
	virtual void OsdProgramme(time_t PresentTime, const char *PresentTitle, const char *PresentSubtitle, time_t FollowingTime, const char *FollowingTitle, const char *FollowingSubtitle);
	virtual void OsdCurrentItem(const char *Text);
	virtual void OsdClear(void);
	virtual void OsdStatusMessage(const char *Message);
	virtual void OsdTitle(const char *Title);

	public:
	cAlcdStatus(aLCD *myLCD);
};

///////////////////////////////////////////////////
// Class cPluginAlcd
class cPluginAlcd : public cPlugin 
{
	private:
  	cAlcdStatus *statusMonitor;
	aLCD *LCD;

	public:
  	cPluginAlcd(void);
  	virtual ~cPluginAlcd();
  	virtual const char *Version(void) { return VERSION; }
  	virtual const char *Description(void) { return DESCRIPTION; }
  	virtual const char *CommandLineHelp(void);
  	virtual bool ProcessArgs(int argc, char *argv[]);
  	virtual bool Start(void);
  	virtual void Housekeeping(void);
  	virtual const char *MainMenuEntry(void) { return MAINMENUENTRY; }
  	virtual cOsdMenu *MainMenuAction(void);
  	virtual cMenuSetupPage *SetupMenu(void);
  	virtual bool SetupParse(const char *Name, const char *Value);
};

///////////////////////////////////////////////////
// Class cMenuSetupAlcd
class cMenuSetupAlcd : public cMenuSetupPage 
{
	private:
  	int newWaitTime;
  	int newRecordLED;
  	int newPowerButton;
  	int newLEDBrightness;
  	int newLEDBrightnessOnExit;

	protected:
  	virtual void Store(void);

	public:
  	cMenuSetupAlcd(void);
};

#endif
